/*
 * Decompiled with CFR 0.152.
 */
package io.github.jasonsimpart.createdelightcore.registry;

import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.simibubi.create.AllTags;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import fr.lucreeper74.createmetallurgy.content.fluids.MoltenFluidSource;
import fr.lucreeper74.createmetallurgy.content.fluids.MoltenFluidType;
import io.github.jasonsimpart.createdelightcore.CreateDelightCore;
import io.github.jasonsimpart.createdelightcore.content.fluid.RadiationFluidType;
import io.github.jasonsimpart.createdelightcore.content.fluid.SlimeFluidType;
import io.github.jasonsimpart.createdelightcore.registry.CDCreativeTabs;
import io.github.jasonsimpart.createdelightcore.registry.CDRegistration;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.DistExecutor;

public class CDFluids {
    public static final ResourceKey<CreativeModeTab> FLUID_TAB = CDCreativeTabs.FLUID.getKey();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_ANDESITE = CDFluids.moltenFluid("andesite");
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_AZURE_NEODYMIUM = CDFluids.moltenFluid("azure_neodymium");
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_SCARLET_NEODYMIUM = CDFluids.moltenFluid("scarlet_neodymium");
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_DESH = CDFluids.moltenFluid("desh");
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_OSTRUM = CDFluids.moltenFluid("ostrum");
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_CLAORITE = CDFluids.moltenFluid("calorite");
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_FIRE_STEEL = CDFluids.moltenFluid("fire_steel");
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_ICE_STEEL = CDFluids.moltenFluid("ice_steel");
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_LIGHTNING_STEEL = CDFluids.moltenFluid("lightning_steel");
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_FORGED_STEEL = CDFluids.moltenFluid("forged_steel");
    public static final FluidEntry<ForgeFlowingFluid.Flowing> SLIME = CDFluids.slimeFluid("slime");
    public static final FluidEntry<ForgeFlowingFluid.Flowing> FERROUSLIME = CDFluids.slimeFluid("ferrouslime");
    public static final FluidEntry<ForgeFlowingFluid.Flowing> NUCLEAR_WASTE = CDFluids.radiationFluid("nuclear_waste");

    public static FluidBuilder<ForgeFlowingFluid.Flowing, Registrate> createFluid(String name) {
        ResourceLocation STILL_RL = CreateDelightCore.id("block/fluid/" + name + "/still");
        ResourceLocation FLOW_RL = CreateDelightCore.id("block/fluid/" + name + "/flowing");
        return CDRegistration.REGISTRATE.fluid(name, STILL_RL, FLOW_RL);
    }

    private static FluidEntry<ForgeFlowingFluid.Flowing> moltenFluid(String name) {
        ResourceLocation STILL_RL = CreateDelightCore.id("block/fluid/" + name + "/still");
        ResourceLocation FLOW_RL = CreateDelightCore.id("block/fluid/" + name + "/flowing");
        return ((FluidBuilder)CDRegistration.REGISTRATE.fluid("molten_" + name, STILL_RL, FLOW_RL, MoltenFluidType::new).properties(b -> b.viscosity(2000).density(1400).lightLevel(15).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11783_).canHydrate(false).canDrown(false).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).tag(new TagKey[]{AllTags.forgeFluidTag((String)("molten_" + name)), AllTags.forgeFluidTag((String)"molten_materials")}).source(MoltenFluidSource::new).bucket().tab(FLUID_TAB).build()).register();
    }

    private static FluidEntry<ForgeFlowingFluid.Flowing> slimeFluid(String name) {
        ResourceLocation STILL_RL = CreateDelightCore.id("block/fluid/" + name + "/still");
        ResourceLocation FLOW_RL = CreateDelightCore.id("block/fluid/" + name + "/flowing");
        FluidBuilder reg = CDRegistration.REGISTRATE.fluid(name, STILL_RL, FLOW_RL, SlimeFluidType::new);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> reg.renderType(RenderType::m_110466_));
        reg.properties(b -> b.viscosity(2000).density(1400).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_12389_).sound(SoundActions.BUCKET_FILL, SoundEvents.f_12389_).canHydrate(false).supportsBoating(true)).fluidProperties(p -> p.levelDecreasePerBlock(3).tickRate(25).slopeFindDistance(3).explosionResistance(50.0f)).source(ForgeFlowingFluid.Source::new).bucket().tab(FLUID_TAB).build();
        return reg.register();
    }

    private static FluidEntry<ForgeFlowingFluid.Flowing> radiationFluid(String name) {
        ResourceLocation STILL_RL = CreateDelightCore.id("block/fluid/" + name + "/still");
        ResourceLocation FLOW_RL = CreateDelightCore.id("block/fluid/" + name + "/flowing");
        return ((FluidBuilder)CDRegistration.REGISTRATE.fluid(name, STILL_RL, FLOW_RL, RadiationFluidType::new).properties(b -> b.viscosity(2000).density(1400).lightLevel(5).sound(SoundActions.BUCKET_EMPTY, (SoundEvent)ACSoundRegistry.ACID_UNSUBMERGE.get()).sound(SoundActions.BUCKET_FILL, (SoundEvent)ACSoundRegistry.ACID_SUBMERGE.get()).canHydrate(true).canDrown(true).canSwim(true)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(5).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).bucket().tab(FLUID_TAB).build()).register();
    }

    public static void init() {
    }
}

